/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.network.PacketUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionsMessage {
    private static final String COLONY_DOES_NOT_EXIST = "Colony #%d does not exist.";

    public static class SetSubscriber
    implements IMessage {
        private int colonyId;
        private int rankId;
        private RegistryKey<World> dimension;
        private boolean isSubscriber;

        public SetSubscriber() {
        }

        public SetSubscriber(@NotNull IColonyView colony, @NotNull Rank rank, @NotNull boolean isSubscriber) {
            this.colonyId = colony.getID();
            this.dimension = colony.getDimension();
            this.rankId = rank.getId();
            this.isSubscriber = isSubscriber;
        }

        @Override
        public void toBytes(PacketBuffer buf) {
            buf.writeInt(this.colonyId);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
            buf.writeInt(this.rankId);
            buf.writeBoolean(this.isSubscriber);
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
            this.colonyId = buf.readInt();
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
            this.rankId = buf.readInt();
            this.isSubscriber = buf.readBoolean();
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, this.dimension);
            if (colony != null && colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.EDIT_PERMISSIONS)) {
                colony.getPermissions().getRank(this.rankId).setSubscriber(this.isSubscriber);
                colony.markDirty();
            }
        }
    }

    public static class EditRankType
    implements IMessage {
        private int colonyId;
        private int rankId;
        private RegistryKey<World> dimension;
        private int rankType;

        public EditRankType() {
        }

        public EditRankType(@NotNull IColonyView colony, @NotNull Rank rank, @NotNull int rankType) {
            this.colonyId = colony.getID();
            this.rankId = rank.getId();
            this.dimension = colony.getDimension();
            this.rankType = rankType;
        }

        @Override
        public void toBytes(PacketBuffer buf) {
            buf.writeInt(this.colonyId);
            buf.writeInt(this.rankId);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
            buf.writeInt(this.rankType);
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
            this.colonyId = buf.readInt();
            this.rankId = buf.readInt();
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
            this.rankType = buf.readInt();
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, this.dimension);
            if (colony != null && colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.EDIT_PERMISSIONS)) {
                Rank rank = colony.getPermissions().getRank(this.rankId);
                switch (this.rankType) {
                    case 0: {
                        rank.setColonyManager(true);
                        rank.setHostile(false);
                        break;
                    }
                    case 1: {
                        rank.setHostile(true);
                        rank.setColonyManager(false);
                        break;
                    }
                    default: {
                        rank.setHostile(false);
                        rank.setColonyManager(false);
                    }
                }
                colony.markDirty();
            }
        }
    }

    public static class RemoveRank
    implements IMessage {
        private int colonyId;
        private int rankId;
        private RegistryKey<World> dimension;

        public RemoveRank() {
        }

        public RemoveRank(@NotNull IColonyView colony, @NotNull Rank rank) {
            this.colonyId = colony.getID();
            this.rankId = rank.getId();
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyId);
            buf.writeInt(this.rankId);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyId = buf.readInt();
            this.rankId = buf.readInt();
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, this.dimension);
            if (colony != null && colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.EDIT_PERMISSIONS)) {
                colony.getPermissions().removeRank(colony.getPermissions().getRanks().get(this.rankId));
            }
        }
    }

    public static class RemovePlayer
    implements IMessage {
        private int colonyID;
        private UUID playerID;
        private RegistryKey<World> dimension;

        public RemovePlayer() {
        }

        public RemovePlayer(@NotNull IColonyView colony, UUID player) {
            this.colonyID = colony.getID();
            this.playerID = player;
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            PacketUtils.writeUUID(buf, this.playerID);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.playerID = PacketUtils.readUUID(buf);
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
                return;
            }
            ServerPlayerEntity player = ctxIn.getSender();
            Player permissionsPlayer = colony.getPermissions().getPlayers().get(this.playerID);
            if (permissionsPlayer.getRank().isHostile() && colony.getPermissions().hasPermission((PlayerEntity)player, Action.EDIT_PERMISSIONS) || !permissionsPlayer.getRank().isHostile() && colony.getPermissions().hasPermission((PlayerEntity)player, Action.EDIT_PERMISSIONS) && colony.getPermissions().getRank((PlayerEntity)player).isColonyManager() || player.func_110124_au().equals(this.playerID)) {
                colony.getPermissions().removePlayer(this.playerID);
            }
        }
    }

    public static class ChangePlayerRank
    implements IMessage {
        private int colonyID;
        private UUID playerID;
        private Rank rank;
        private RegistryKey<World> dimension;

        public ChangePlayerRank() {
        }

        public ChangePlayerRank(@NotNull IColonyView colony, UUID player, Rank rank) {
            this.colonyID = colony.getID();
            this.playerID = player;
            this.dimension = colony.getDimension();
            this.rank = rank;
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            PacketUtils.writeUUID(buf, this.playerID);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
            buf.writeInt(this.rank.getId());
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.playerID = PacketUtils.readUUID(buf);
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            this.rank = colony.getPermissions().getRank(buf.readInt());
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony == null || colony.getWorld() == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
                return;
            }
            ServerPlayerEntity player = ctxIn.getSender();
            if (colony.getPermissions().hasPermission((PlayerEntity)player, Action.EDIT_PERMISSIONS)) {
                IPermissions iPermissions = colony.getPermissions();
                colony.getPermissions();
                if (this.rank != iPermissions.getRank(0)) {
                    Log.getLogger().error(this.rank.getName());
                    colony.getPermissions().setPlayerRank(this.playerID, this.rank, colony.getWorld());
                }
            }
        }
    }

    public static class AddPlayerOrFakePlayer
    implements IMessage {
        private int colonyID;
        private String playerName;
        private UUID id;
        private RegistryKey<World> dimension;

        public AddPlayerOrFakePlayer() {
        }

        public AddPlayerOrFakePlayer(@NotNull IColonyView colony, String playerName, UUID id) {
            this.colonyID = colony.getID();
            this.playerName = playerName;
            this.id = id;
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.func_180714_a(this.playerName);
            PacketUtils.writeUUID(buf, this.id);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.playerName = buf.func_150789_c(Short.MAX_VALUE);
            this.id = PacketUtils.readUUID(buf);
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony != null && colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.EDIT_PERMISSIONS) && colony.getWorld() != null) {
                IPermissions iPermissions = colony.getPermissions();
                IPermissions iPermissions2 = colony.getPermissions();
                colony.getPermissions();
                iPermissions.addPlayer(this.id, this.playerName, iPermissions2.getRank(3));
            } else {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
            }
        }
    }

    public static class AddRank
    implements IMessage {
        private int colonyID;
        private String rankName;
        private RegistryKey<World> dimension;

        public AddRank() {
        }

        public AddRank(@NotNull IColonyView colony, @NotNull String name) {
            this.colonyID = colony.getID();
            this.rankName = name;
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.func_180714_a(this.rankName);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.rankName = buf.func_150789_c(Short.MAX_VALUE);
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony != null && colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.EDIT_PERMISSIONS)) {
                colony.getPermissions().addRank(this.rankName);
            }
        }
    }

    public static class AddPlayer
    implements IMessage {
        private int colonyID;
        private String playerName;
        private RegistryKey<World> dimension;

        public AddPlayer() {
        }

        public AddPlayer(@NotNull IColonyView colony, String player) {
            this.colonyID = colony.getID();
            this.playerName = player;
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.func_180714_a(this.playerName);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.playerName = buf.func_150789_c(Short.MAX_VALUE);
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony != null && colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.EDIT_PERMISSIONS) && colony.getWorld() != null) {
                IPermissions iPermissions = colony.getPermissions();
                IPermissions iPermissions2 = colony.getPermissions();
                colony.getPermissions();
                iPermissions.addPlayer(this.playerName, iPermissions2.getRank(3), colony.getWorld());
            } else {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
            }
        }
    }

    public static class Permission
    implements IMessage {
        private int colonyID;
        private MessageType type;
        private Rank rank;
        private Action action;
        private RegistryKey<World> dimension;

        public Permission() {
        }

        public Permission(@NotNull IColonyView colony, MessageType type, Rank rank, Action action) {
            this.colonyID = colony.getID();
            this.type = type;
            this.rank = rank;
            this.action = action;
            this.dimension = colony.getDimension();
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
                return;
            }
            if (!colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.EDIT_PERMISSIONS)) {
                return;
            }
            switch (this.type) {
                case SET_PERMISSION: {
                    colony.getPermissions().setPermission(this.rank, this.action);
                    break;
                }
                case REMOVE_PERMISSION: {
                    colony.getPermissions().removePermission(this.rank, this.action);
                    break;
                }
                case TOGGLE_PERMISSION: {
                    colony.getPermissions().togglePermission(this.rank, this.action);
                    break;
                }
                default: {
                    Log.getLogger().error(String.format("Invalid MessageType %s", this.type.toString()), (Throwable)new Exception());
                }
            }
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.func_180714_a(this.type.name());
            buf.writeInt(this.rank.getId());
            buf.func_180714_a(this.action.name());
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.type = MessageType.valueOf(buf.func_150789_c(Short.MAX_VALUE));
            int rankId = buf.readInt();
            this.action = Action.valueOf(buf.func_150789_c(Short.MAX_VALUE));
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony != null) {
                this.rank = colony.getPermissions().getRanks().get(rankId);
            }
        }
    }

    public static class View
    implements IMessage {
        private int colonyID;
        private PacketBuffer data;
        private RegistryKey<World> dimension;

        public View() {
        }

        public View(@NotNull Colony colony, @NotNull Rank viewerRank) {
            this.colonyID = colony.getID();
            this.data = new PacketBuffer(Unpooled.buffer());
            colony.getPermissions().serializeViewNetworkData(this.data, viewerRank);
            this.dimension = colony.getDimension();
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            PacketBuffer newBuf = new PacketBuffer(buf.retain());
            this.colonyID = newBuf.readInt();
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(newBuf.func_150789_c(Short.MAX_VALUE)));
            this.data = newBuf;
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.CLIENT;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColonyManager.getInstance().handlePermissionsViewMessage(this.colonyID, this.data, this.dimension);
            this.data.release();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.func_180714_a(this.dimension.func_240901_a_().toString());
            buf.writeBytes((ByteBuf)this.data);
        }
    }

    public static enum MessageType {
        SET_PERMISSION,
        REMOVE_PERMISSION,
        TOGGLE_PERMISSION;

    }
}

